<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

require_once(__DIR__ . '/../../config.php');
require_once($CFG->dirroot . '/mod/combinedview/lib.php');

$id = required_param('id', PARAM_INT);
$courseid = optional_param('courseid', false, PARAM_INT);

list($course, $cm) = get_course_and_cm_from_cmid($id, 'combinedview');
require_course_login($course, true, $cm);
$combinedview = $PAGE->activityrecord;

$context = context_module::instance($cm->id);

if ($course->id == SITEID) {
    $PAGE->set_pagelayout('incourse');
}
$PAGE->set_url('/mod/combinedview/view.php', array('id' => $cm->id));

$PAGE->set_heading($course->fullname);
$PAGE->add_body_class('limitedwidth');

$now = time();
$isopen = true;
if (!empty($combinedview->timeopen) && $now < $combinedview->timeopen) {
    $isopen = false;
}
if (!empty($combinedview->timeclose) && $now > $combinedview->timeclose) {
    $isopen = false;
}

$selectedforms = combinedview_get_selected_forms($combinedview->id);

try {
    $event = \mod_combinedview\event\course_module_viewed::create(array(
        'objectid' => $combinedview->id,
        'context' => $context,
    ));
    $event->add_record_snapshot('course_modules', $cm);
    $event->add_record_snapshot('course', $course);
    $event->add_record_snapshot('combinedview', $combinedview);
    $event->trigger();
} catch (Exception $e) {
    debugging('Error triggering combinedview course module viewed event: ' . $e->getMessage());
}

echo $OUTPUT->header();

echo $OUTPUT->box_start('generalbox combinedview_description');
$options = (object)array('noclean' => true);
echo format_module_intro('combinedview', $combinedview, $cm->id);
echo $OUTPUT->box_end();

if (!$isopen) {
    echo $OUTPUT->notification(get_string('combinedviewclosed', 'combinedview'), 'notifyinfo');
    echo $OUTPUT->footer();
    exit;
}

if (!has_capability('mod/combinedview:view', $context)) {
    echo $OUTPUT->notification(get_string('cannotaccess', 'combinedview'), 'error');
    echo $OUTPUT->footer();
    exit;
}

if (empty($selectedforms)) {
    echo $OUTPUT->notification(get_string('noformsselected', 'combinedview'), 'notifyinfo');
    echo $OUTPUT->footer();
    exit;
}

echo html_writer::start_tag('form', array(
    'method' => 'post',
    'action' => new moodle_url('/mod/combinedview/submit.php'),
    'id' => 'combinedview-form',
    'enctype' => 'multipart/form-data'
));

echo html_writer::empty_tag('input', array(
    'type' => 'hidden',
    'name' => 'id',
    'value' => $cm->id
));

echo html_writer::empty_tag('input', array(
    'type' => 'hidden',
    'name' => 'sesskey',
    'value' => sesskey()
));

foreach ($selectedforms as $form) {
    $formhtml = combinedview_render_form($form->type, $form->formid, $course->id);
    if (!empty($formhtml)) {
        echo $formhtml;
        echo html_writer::tag('hr', '', array('class' => 'combinedview-separator'));
    }
}

echo html_writer::start_tag('div', array('class' => 'combinedview-submit-container'));
echo html_writer::tag('button', get_string('submitallforms', 'combinedview'), array(
    'type' => 'submit',
    'class' => 'btn btn-primary btn-lg',
    'id' => 'submit-all-forms'
));
echo html_writer::end_tag('div');

echo html_writer::end_tag('form');

echo html_writer::tag('style', '
    .combinedview-form {
        margin-bottom: 30px;
        padding: 20px;
        border: 1px solid #ddd;
        border-radius: 5px;
        background-color: #f9f9f9;
    }
    .combinedview-form h3 {
        margin-top: 0;
        color: #333;
        border-bottom: 2px solid #007bff;
        padding-bottom: 10px;
    }
    .combinedview-separator {
        margin: 40px 0;
        border: none;
        border-top: 2px solid #007bff;
    }
    .combinedview-submit-container {
        text-align: center;
        margin: 30px 0;
        padding: 20px;
        background-color: #e9ecef;
        border-radius: 5px;
    }
    .feedback-form, .data-form, .questionnaire-form {
        background-color: white;
        border: 1px solid #ccc;
        border-radius: 3px;
        padding: 15px;
        margin: 10px 0;
    }
    .data-field, .questionnaire-question {
        margin: 10px 0;
    }
    .data-field label, .questionnaire-question label {
        font-weight: bold;
        display: block;
        margin-bottom: 5px;
    }
    .data-field input, .questionnaire-question input {
        width: 100%;
        padding: 8px;
        border: 1px solid #ccc;
        border-radius: 3px;
    }
    .assignment-form {
        background-color: white;
        border: 1px solid #ccc;
        border-radius: 3px;
        padding: 15px;
        margin: 10px 0;
    }
    .assignment-intro {
        margin-bottom: 15px;
        padding: 10px;
        background-color: #f8f9fa;
        border-radius: 3px;
    }
    .assignment-submission {
        margin-top: 15px;
    }
    .assignment-field {
        margin: 15px 0;
    }
    .assignment-field label {
        font-weight: bold;
        display: block;
        margin-bottom: 5px;
        color: #333;
    }
    .assignment-field textarea,
    .assignment-field input[type="file"] {
        width: 100%;
        padding: 8px;
        border: 1px solid #ccc;
        border-radius: 3px;
    }
    .assignment-field textarea {
        resize: vertical;
        min-height: 100px;
    }
    .form-text {
        font-size: 0.875em;
        color: #6c757d;
        margin-top: 5px;
    }
    .feedback-item {
        margin: 15px 0;
        padding: 10px;
        border: 1px solid #e9ecef;
        border-radius: 5px;
        background-color: #f8f9fa;
    }
    .feedback-item label {
        font-weight: bold;
        display: block;
        margin-bottom: 8px;
        color: #333;
    }
    .feedback-item input[type="text"],
    .feedback-item input[type="number"],
    .feedback-item textarea {
        width: 100%;
        padding: 8px;
        border: 1px solid #ccc;
        border-radius: 3px;
        font-size: 14px;
    }
    .feedback-item textarea {
        resize: vertical;
        min-height: 80px;
    }
    .feedback-info,
    .feedback-label {
        padding: 10px;
        margin: 10px 0;
        border-left: 4px solid #007bff;
        background-color: #e7f3ff;
        border-radius: 3px;
    }
    .feedback-info {
        font-style: italic;
        color: #666;
    }
    .feedback-label {
        font-weight: bold;
        color: #333;
    }
    .form-check {
        margin: 8px 0;
        padding: 5px 0;
    }
    .form-check-input {
        margin-right: 8px;
    }
    .form-check-label {
        font-weight: normal;
        cursor: pointer;
    }
    .form-check:hover {
        background-color: #f8f9fa;
        border-radius: 3px;
        padding: 3px 5px;
    }
');

echo html_writer::tag('script', '
    document.addEventListener("DOMContentLoaded", function() {
        var form = document.getElementById("combinedview-form");
        var submitButton = document.getElementById("submit-all-forms");
        
        if (form && submitButton) {
            form.addEventListener("submit", function(e) {
                submitButton.disabled = true;
                submitButton.textContent = "' . get_string('submitting', 'combinedview') . '";
            });
        }
    });
');

echo $OUTPUT->footer(); 