<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

require_once(__DIR__ . '/../../config.php');
require_once($CFG->dirroot . '/mod/combinedview/lib.php');

$id = required_param('id', PARAM_INT);

list($course, $cm) = get_course_and_cm_from_cmid($id, 'combinedview');
require_course_login($course, true, $cm);
$combinedview = $PAGE->activityrecord;

$PAGE->set_url('/mod/combinedview/submit.php', array('id' => $id));

$context = context_module::instance($cm->id);

if (!has_capability('mod/combinedview:view', $context)) {
    throw new moodle_exception('cannotaccess', 'combinedview');
}

$now = time();
$isopen = true;
if (!empty($combinedview->timeopen) && $now < $combinedview->timeopen) {
    throw new moodle_exception('combinedviewclosed', 'combinedview');
}
if (!empty($combinedview->timeclose) && $now > $combinedview->timeclose) {
    throw new moodle_exception('combinedviewclosed', 'combinedview');
}

require_sesskey();

$formdata = $_POST;

$success = combinedview_process_submission($combinedview->id, $formdata);

$redirecturl = new moodle_url('/mod/combinedview/view.php', array('id' => $cm->id));

if ($success) {
    try {
        $event = \mod_combinedview\event\submission_created::create(array(
            'objectid' => $combinedview->id,
            'context' => $context,
            'relateduserid' => $USER->id,
        ));
        $event->add_record_snapshot('course_modules', $cm);
        $event->add_record_snapshot('course', $course);
        $event->add_record_snapshot('combinedview', $combinedview);
        $event->trigger();
    } catch (Exception $e) {
        debugging('Error triggering combinedview submission created event: ' . $e->getMessage());
    }

    redirect($redirecturl, get_string('submissionsuccessful', 'combinedview'), 3);
} else {
    redirect($redirecturl, get_string('submissionfailed', 'combinedview'), 3, 'error');
} 