<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

if (!defined('MOODLE_INTERNAL')) {
    die('Direct access to this script is forbidden.');
}

require_once($CFG->dirroot.'/course/moodleform_mod.php');

class mod_combinedview_mod_form extends moodleform_mod {

    public function definition() {
        global $CFG, $DB;

        $mform =& $this->_form;

        $mform->addElement('header', 'general', get_string('general', 'form'));

        $mform->addElement('text', 'name', get_string('name'), array('size'=>'64'));
        $mform->setType('name', PARAM_TEXT);
        $mform->addRule('name', null, 'required', null, 'client');
        $mform->addRule('name', get_string('maximumchars', '', 1333), 'maxlength', 1333, 'client');

        $this->standard_intro_elements(get_string('description', 'combinedview'));

        $mform->addElement('header', 'formshdr', get_string('selectforms', 'combinedview'));

        $courseid = $this->get_course_id();
        $availableforms = combinedview_get_available_forms($courseid);

        if (empty($availableforms)) {
            $mform->addElement('static', 'noforms', '', get_string('noformsavailable', 'combinedview'));
        } else {
            $mform->addElement('select', 'selected_forms', get_string('selectforms', 'combinedview'), 
                $availableforms, array('multiple' => 'multiple', 'size' => 10));
            $mform->setType('selected_forms', PARAM_TEXT);
            $mform->addHelpButton('selected_forms', 'selectforms', 'combinedview');
            
            $mform->addElement('html', '<script type="text/javascript">
                document.addEventListener("DOMContentLoaded", function() {
                    var select = document.getElementById("id_selected_forms");
                    if (select) {
                        select.style.width = "100%";
                        select.style.minHeight = "200px";
                    }
                });
            </script>');
            
            $mform->addElement('static', 'selection_note', '', 
                get_string('selectforms_help', 'combinedview'));
        }

        $mform->addElement('header', 'timinghdr', get_string('availability', 'combinedview'));

        $mform->addElement('date_time_selector', 'timeopen', get_string('combinedviewopen', 'combinedview'),
            array('optional' => true));

        $mform->addElement('date_time_selector', 'timeclose', get_string('combinedviewclose', 'combinedview'),
            array('optional' => true));

        $this->standard_coursemodule_elements();

        $this->add_action_buttons();
    }

    private function get_course_id() {
        global $COURSE;
        
        if (isset($this->_customdata['course'])) {
            return $this->_customdata['course']->id;
        }
        
        if (isset($COURSE->id)) {
            return $COURSE->id;
        }
        
        return 0;
    }

    public function data_preprocessing(&$default_values) {
        parent::data_preprocessing($default_values);

        if ($this->current && isset($this->current->id) && !empty($this->current->id)) {
            $selectedforms = combinedview_get_selected_forms($this->current->id);
            if ($selectedforms) {
                $formkeys = array();
                foreach ($selectedforms as $form) {
                    $formkeys[] = $form->formtype . '_' . $form->formid;
                }
                $default_values['selected_forms'] = $formkeys;
            }
        }
    }

    public function validation($data, $files) {
        $errors = parent::validation($data, $files);

        if (isset($data['selected_forms'])) {
            if (is_array($data['selected_forms'])) {
                $hasSelection = false;
                foreach ($data['selected_forms'] as $form) {
                    if (!empty($form)) {
                        $hasSelection = true;
                        break;
                    }
                }
                if (!$hasSelection) {
                    $errors['selected_forms'] = get_string('error_noformsselected', 'combinedview');
                }
            } else {
                if (empty($data['selected_forms'])) {
                    $errors['selected_forms'] = get_string('error_noformsselected', 'combinedview');
                }
            }
        } else {
            $errors['selected_forms'] = get_string('error_noformsselected', 'combinedview');
        }

        if (!empty($data['timeopen']) && !empty($data['timeclose'])) {
            if ($data['timeopen'] >= $data['timeclose']) {
                $errors['timeclose'] = get_string('error_invalidtiming', 'combinedview');
            }
        }

        return $errors;
    }
} 