<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

namespace mod_combinedview\event;

defined('MOODLE_INTERNAL') || die();

class course_module_viewed extends \core\event\base {

    protected function init() {
        $this->data['objecttable'] = 'combinedview';
        $this->data['crud'] = 'r';
        $this->data['edulevel'] = self::LEVEL_PARTICIPATING;
        $this->data['level'] = self::LEVEL_PARTICIPATING;
    }

    public static function get_name() {
        return get_string('eventcoursemoduleviewed', 'combinedview');
    }

    public function get_description() {
        return "The user with id '$this->userid' viewed the combined view activity with course module id '$this->contextinstanceid'.";
    }

    public function get_url() {
        return new \moodle_url('/mod/combinedview/view.php', array('id' => $this->contextinstanceid));
    }

    protected function get_legacy_logdata() {
        return array($this->courseid, 'combinedview', 'view', 'view.php?id=' . $this->contextinstanceid,
            $this->objectid, $this->contextinstanceid);
    }
} 