<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/backup/moodle2/restore_activity_task.class.php');

class restore_combinedview_activity_task extends restore_activity_task {

    protected function define_my_settings() {
    }

    protected function define_my_steps() {
        $this->add_step(new restore_combinedview_activity_structure_step('combinedview_structure', 'combinedview.xml'));
    }

    static public function define_decode_contents() {
        $contents = array();

        $contents[] = new restore_decode_content('combinedview', array('intro'), 'combinedview');

        return $contents;
    }

    static public function define_decode_rules() {
        $rules = array();

        $rules[] = new restore_decode_rule('COMBINEDVIEWINDEX', '/mod/combinedview/index.php?id=$1', 'course');
        $rules[] = new restore_decode_rule('COMBINEDVIEWVIEWBYID', '/mod/combinedview/view.php?id=$1', 'course_module');

        return $rules;
    }

    static public function define_restore_log_rules() {
        $rules = array();

        $rules[] = new restore_log_rule('combinedview', 'add', 'view.php?id={course_module}', '{combinedview}');
        $rules[] = new restore_log_rule('combinedview', 'update', 'view.php?id={course_module}', '{combinedview}');
        $rules[] = new restore_log_rule('combinedview', 'view', 'view.php?id={course_module}', '{combinedview}');
        $rules[] = new restore_log_rule('combinedview', 'submit', 'view.php?id={course_module}', '{combinedview}');

        return $rules;
    }

    static public function define_restore_log_rules_for_course() {
        $rules = array();

        $rules[] = new restore_log_rule('combinedview', 'view all', 'index.php?id={course}', null);

        return $rules;
    }
} 