<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

defined('MOODLE_INTERNAL') || die();

class restore_combinedview_activity_structure_step extends restore_activity_structure_step {

    protected function define_structure() {

        $paths = array();
        $userinfo = $this->get_setting_value('userinfo');

        $paths[] = new restore_path_element('combinedview', '/activity/combinedview');
        $paths[] = new restore_path_element('combinedview_form', '/activity/combinedview/forms/form');

        return $this->prepare_activity_structure($paths);
    }

    protected function process_combinedview($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;
        $data->course = $this->get_courseid();

        $data->timeopen = $this->apply_date_offset($data->timeopen);
        $data->timeclose = $this->apply_date_offset($data->timeclose);
        $data->timemodified = $this->apply_date_offset($data->timemodified);

        $newitemid = $DB->insert_record('combinedview', $data);
        $this->apply_activity_instance($newitemid);
    }

    protected function process_combinedview_form($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;

        $data->combinedviewid = $this->get_new_parentid('combinedview');
        $data->formid = $this->get_mappingid('course_module', $data->formid);

        $newitemid = $DB->insert_record('combinedview_forms', $data);
        $this->set_mapping('combinedview_form', $oldid, $newitemid);
    }

    protected function after_execute() {
        $this->add_related_files('mod_combinedview', 'intro', null);
    }
} 