<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

defined('MOODLE_INTERNAL') || die();

class backup_combinedview_activity_structure_step extends backup_activity_structure_step {

    protected function define_structure() {

        $userinfo = $this->get_setting_value('userinfo');

        $combinedview = new backup_nested_element('combinedview', array('id'), array(
            'name', 'intro', 'introformat', 'timeopen', 'timeclose', 'timemodified'));

        $forms = new backup_nested_element('forms');
        $form = new backup_nested_element('form', array('id'), array(
            'combinedviewid', 'formid', 'formtype', 'sortorder'));

        $combinedview->add_child($forms);
        $forms->add_child($form);

        $combinedview->set_source_table('combinedview', array('id' => backup::VAR_ACTIVITYID));
        $form->set_source_table('combinedview_forms', array('combinedviewid' => backup::VAR_PARENTID));

        $form->annotate_ids('course_module', 'formid');

        $combinedview->annotate_files('mod_combinedview', 'intro', null);

        return $this->prepare_activity_structure($combinedview);
    }
} 