# Visão Combinada (Combined View) - Plugin Moodle

**Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)**  
**Contato: contato@levelsistemas.com.br**  
**Autor: José Luiz Neto**

## Descrição

O plugin "Visão Combinada" é um módulo de atividade para o Moodle que permite aos professores combinar múltiplos formulários (feedback, data, questionnaire) em uma única atividade. Os alunos podem preencher todos os formulários de uma vez e enviá-los com um único clique.

## Funcionalidades

### Para Professores:
- Criar uma nova atividade "Visão Combinada"
- Selecionar múltiplos formulários de diferentes tipos:
  - Formulários de Feedback (mod_feedback) - **Suporte completo a todos os tipos de questões**
  - Formulários de Dados (mod_data)
  - Questionários (mod_questionnaire) - se disponível
  - Atividades de Tarefa (mod_assign)
- Definir período de disponibilidade (abertura e fechamento)
- Configurar descrição e outras opções padrão do Moodle

### Para Alunos:
- Visualizar todos os formulários selecionados em uma única página
- Preencher todos os formulários de uma vez
- Enviar todos os dados com um único botão "Salvar"
- Receber confirmação de sucesso ou erro no envio

### Tipos de Questões do Feedback Suportados:
- **textfield** - Campo de texto simples
- **textarea** - Área de texto
- **numeric** - Campo numérico
- **multichoice** - Múltipla escolha (radio/checkbox/dropdown)
- **multichoicerated** - Múltipla escolha com avaliação
- **info** - Informação (apenas exibição)
- **label** - Rótulo (apenas exibição)

## Instalação

1. Copie a pasta `combinedview` para o diretório `mod/` do seu Moodle
2. Acesse o painel de administração do Moodle
3. Vá para "Notificações" para instalar o plugin
4. O Moodle detectará automaticamente o novo módulo e criará as tabelas necessárias

## Estrutura do Plugin

```
mod/combinedview/
├── classes/event/
│   ├── course_module_viewed.php
│   └── submission_created.php
├── db/
│   ├── access.php
│   └── install.xml
├── lang/
│   ├── en/
│   │   └── combinedview.php
│   └── pt_br/
│       └── combinedview.php
├── lib.php
├── mod_form.php
├── submit.php
├── view.php
├── version.php
└── README.md
```

## Tabelas do Banco de Dados

### combinedview
Armazena as instâncias do módulo:
- `id`: ID único da instância
- `course`: ID do curso
- `name`: Nome da atividade
- `intro`: Descrição da atividade
- `introformat`: Formato da descrição
- `timeopen`: Data/hora de abertura
- `timeclose`: Data/hora de fechamento
- `timemodified`: Data/hora da última modificação

### combinedview_forms
Armazena os formulários selecionados para cada instância:
- `id`: ID único do registro
- `combinedviewid`: ID da instância combinedview
- `formid`: ID do formulário original
- `formtype`: Tipo do formulário (feedback, data, questionnaire)
- `sortorder`: Ordem de exibição

## Capacidades (Capabilities)

- `mod/combinedview:addinstance`: Adicionar uma nova Visão Combinada
- `mod/combinedview:view`: Visualizar Visão Combinada
- `mod/combinedview:submit`: Enviar formulários combinados

## Eventos

O plugin registra os seguintes eventos:
- `course_module_viewed`: Quando um usuário visualiza a atividade
- `submission_created`: Quando um usuário submete todos os formulários

## Compatibilidade

- Moodle 4.0+
- PHP 7.4+
- Suporta formulários dos módulos:
  - mod_feedback
  - mod_data
  - mod_questionnaire (se instalado)
  - mod_assign

## Limitações Conhecidas

1. O plugin depende da disponibilidade dos módulos de formulário no curso
2. A validação é feita individualmente para cada formulário
3. Alguns plugins de terceiros podem não ser compatíveis

## Desenvolvimento

### Adicionando Novos Tipos de Formulário

Para adicionar suporte a novos tipos de formulário:

1. Atualize a função `combinedview_get_available_forms()` em `lib.php`
2. Adicione uma nova função de renderização `combinedview_render_[type]_form()`
3. Adicione uma nova função de processamento `combinedview_process_[type]_submission()`
4. Atualize a função `combinedview_render_form()` para incluir o novo tipo

### Adicionando Novos Tipos de Questões do Feedback

Para adicionar suporte a novos tipos de questões do feedback:

1. Adicione um novo `case` na função `combinedview_render_feedback_form()` em `lib.php`
2. Implemente a lógica de renderização específica para o tipo
3. Atualize a função `combinedview_process_feedback_submission()` se necessário
4. Adicione estilos CSS apropriados em `view.php`

### Personalização de Estilos

Os estilos CSS estão incluídos no arquivo `view.php`. Para personalizar:

1. Edite a seção `<style>` no arquivo `view.php`
2. Ou crie um arquivo CSS separado e inclua-o

## Suporte

Para suporte e dúvidas, entre em contato com o desenvolvedor.

## Licença

Este plugin está licenciado sob a GNU General Public License v3.0.

## Autor

José Luiz Neto 