# Manual do Usuário - Plugin Visão Combinada

**Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)**  
**Contato: contato@levelsistemas.com.br**  
**Autor: José Luiz Neto**

---

## Índice

1. [O que é o Plugin Visão Combinada?](#o-que-é-o-plugin-visão-combinada)
2. [Como Funciona](#como-funciona)
3. [Para Professores](#para-professores)
   - [Criando uma Visão Combinada](#criando-uma-visão-combinada)
   - [Configurando a Atividade](#configurando-a-atividade)
   - [Gerenciando Formulários](#gerenciando-formulários)
   - [Configurando Disponibilidade](#configurando-disponibilidade)
4. [Para Alunos](#para-alunos)
   - [Acessando a Atividade](#acessando-a-atividade)
   - [Preenchendo os Formulários](#preenchendo-os-formulários)
   - [Enviando os Dados](#enviando-os-dados)
   - [Confirmando o Envio](#confirmando-o-envio)
5. [Tipos de Formulários Suportados](#tipos-de-formulários-suportados)
6. [Dicas e Truques](#dicas-e-truques)
7. [Solução de Problemas](#solução-de-problemas)
8. [Perguntas Frequentes](#perguntas-frequentes)

---

## O que é o Plugin Visão Combinada?

O **Plugin Visão Combinada** é uma ferramenta especial do Moodle que permite combinar vários formulários diferentes em uma única atividade. Imagine que você tem um questionário, um formulário de feedback e uma atividade de tarefa - com este plugin, você pode juntar todos eles em uma só página para que os alunos preencham tudo de uma vez!

### Principais Vantagens:

✅ **Economia de tempo** - Os alunos não precisam navegar entre várias páginas  
✅ **Organização** - Todos os formulários ficam organizados em um só lugar  
✅ **Facilidade** - Um único botão para enviar tudo  
✅ **Flexibilidade** - Funciona com diferentes tipos de formulários  

---

## Como Funciona

O plugin funciona como um "conteiner" que reúne formulários existentes no seu curso. Ele não cria novos formulários, mas sim combina os que já existem.

### Fluxo de Funcionamento:

1. **Professor** cria formulários individuais (feedback, questionários, etc.)
2. **Professor** cria uma "Visão Combinada" e seleciona quais formulários incluir
3. **Alunos** acessam a Visão Combinada e veem todos os formulários juntos
4. **Alunos** preenchem todos os formulários na mesma página
5. **Alunos** clicam em "Enviar todos os formulários" uma única vez
6. **Sistema** processa e salva todos os dados automaticamente

---

## Para Professores

### Criando uma Visão Combinada

#### Passo 1: Preparar os Formulários Base
Antes de criar uma Visão Combinada, você precisa ter formulários no seu curso:

1. Vá para o seu curso no Moodle
2. Ative o "Modo de edição" (botão no canto superior direito)
3. Crie os formulários que deseja combinar:
   - **Formulário de Feedback**: "Adicionar uma atividade ou recurso" → "Feedback"
   - **Banco de Dados**: "Adicionar uma atividade ou recurso" → "Banco de Dados"
   - **Questionário**: "Adicionar uma atividade ou recurso" → "Questionário"
   - **Tarefa**: "Adicionar uma atividade ou recurso" → "Tarefa"

#### Passo 2: Criar a Visão Combinada
1. No seu curso, clique em "Adicionar uma atividade ou recurso"
2. Procure por "**Visão Combinada**" na lista
3. Clique em "Adicionar"

### Configurando a Atividade

#### Informações Básicas
- **Nome da atividade**: Escolha um nome claro e descritivo
- **Descrição**: Explique aos alunos o que eles devem fazer

#### Selecionando Formulários
Esta é a parte mais importante! Aqui você escolhe quais formulários serão combinados:

1. **Lista de formulários disponíveis**: Você verá todos os formulários do seu curso
2. **Seleção múltipla**: Pode selecionar vários formulários de uma vez
3. **Diferentes tipos**: Pode misturar feedback, questionários, bancos de dados e tarefas

**Dica**: Use Ctrl+clique (ou Cmd+clique no Mac) para selecionar múltiplos formulários.

#### Configurando Disponibilidade

**Data de abertura**: Quando os alunos poderão começar a preencher
- Deixe em branco se quiser que esteja sempre disponível
- Use para controlar quando a atividade fica ativa

**Data de fechamento**: Quando os alunos não poderão mais preencher
- Importante para definir prazos
- Após esta data, a atividade fica inacessível

### Gerenciando Formulários

#### Ordem de Exibição
Os formulários aparecem na ordem em que foram criados. Para alterar a ordem:
1. Edite a Visão Combinada
2. Remova todos os formulários
3. Adicione novamente na ordem desejada

#### Adicionando/Removendo Formulários
- **Adicionar**: Selecione novos formulários na lista
- **Remover**: Desmarque os formulários que não quer mais

#### Verificando Formulários
Antes de publicar, verifique se:
- Todos os formulários estão configurados corretamente
- Os alunos têm permissão para acessar cada formulário
- Não há conflitos entre os formulários

### Configurando Disponibilidade

#### Controle de Acesso
- **Sempre disponível**: Deixe as datas em branco
- **Período específico**: Defina data de abertura e fechamento
- **Apenas fechamento**: Defina apenas a data limite

#### Configurações Avançadas
- **Visibilidade**: Pode ocultar a atividade até a data de abertura
- **Notificações**: Configure lembretes para os alunos
- **Restrições**: Use condições de conclusão se necessário

---

## Para Alunos

### Acessando a Atividade

1. **Entre no curso** onde está a Visão Combinada
2. **Procure pela atividade** "Visão Combinada" na lista
3. **Clique no nome** da atividade para abrir

### Preenchendo os Formulários

#### Interface da Atividade
Quando você abrir a Visão Combinada, verá:

- **Descrição da atividade** no topo
- **Cada formulário** em uma seção separada
- **Linhas separadoras** entre os formulários
- **Botão de envio** no final da página

#### Navegando pelos Formulários
- **Rolagem**: Use a roda do mouse para navegar
- **Seções**: Cada formulário tem seu próprio título
- **Campos**: Preencha normalmente como faria em formulários separados

#### Tipos de Campos
Você pode encontrar diferentes tipos de campos:

**Campos de texto:**
- Caixas de texto simples
- Áreas de texto maiores
- Campos de data/hora

**Campos de seleção:**
- Caixas de seleção (múltipla escolha)
- Botões de rádio (escolha única)
- Listas suspensas

**Campos de arquivo:**
- Upload de arquivos
- Seleção de múltiplos arquivos

### Enviando os Dados

#### Antes de Enviar
Verifique se:
- ✅ Todos os campos obrigatórios estão preenchidos
- ✅ Os arquivos foram anexados corretamente
- ✅ As respostas estão como você deseja

#### Processo de Envio
1. **Clique no botão** "Enviar todos os formulários"
2. **Aguarde** o processamento (pode demorar alguns segundos)
3. **Confirme** se apareceu a mensagem de sucesso

#### O que Acontece Durante o Envio
O sistema:
- Valida todos os dados
- Salva as respostas em cada formulário original
- Processa arquivos anexados
- Registra a submissão completa

### Confirmando o Envio

#### Mensagens de Sucesso
Se tudo der certo, você verá:
- ✅ "Todos os formulários foram enviados com sucesso!"
- ✅ Confirmação de que os dados foram salvos

#### Mensagens de Erro
Se houver problemas:
- ❌ "Erro ao enviar os formulários. Tente novamente."
- ❌ Lista de campos que precisam ser corrigidos

#### O que Fazer em Caso de Erro
1. **Verifique os campos** destacados em vermelho
2. **Preencha** os campos obrigatórios
3. **Tente novamente** clicando no botão de envio
4. **Se persistir**, entre em contato com o professor

---

## Tipos de Formulários Suportados

### 1. Formulários de Feedback
**O que são**: Questionários de avaliação e coleta de opiniões
**Campos típicos**: Texto, múltipla escolha, escala de avaliação
**Uso comum**: Avaliação de cursos, pesquisas de satisfação

### 2. Bancos de Dados
**O que são**: Formulários para coleta de informações estruturadas
**Campos típicos**: Texto, números, datas, imagens, arquivos
**Uso comum**: Cadastros, inventários, coleta de dados

### 3. Questionários
**O que são**: Ferramentas avançadas de pesquisa (se instaladas)
**Campos típicos**: Perguntas complexas, lógica condicional
**Uso comum**: Pesquisas acadêmicas, avaliações detalhadas

### 4. Tarefas
**O que são**: Atividades para entrega de trabalhos
**Campos típicos**: Texto online, upload de arquivos, comentários
**Uso comum**: Entrega de trabalhos, relatórios, projetos

---

## Dicas e Truques

### Para Professores

#### Organização
- **Nomeie claramente** cada formulário para facilitar a identificação
- **Use descrições** para explicar o que cada formulário coleta
- **Teste sempre** antes de disponibilizar para os alunos

#### Configuração
- **Comece simples**: Use poucos formulários no início
- **Teste a funcionalidade**: Preencha você mesmo antes de publicar
- **Verifique permissões**: Certifique-se de que os alunos podem acessar

#### Manutenção
- **Monitore o uso**: Verifique se os alunos estão conseguindo usar
- **Colete feedback**: Peça opiniões sobre a experiência
- **Faça ajustes**: Melhore baseado no feedback recebido

### Para Alunos

#### Preparação
- **Leia a descrição** da atividade antes de começar
- **Prepare os arquivos** que precisa anexar
- **Reserve tempo** suficiente para preencher tudo

#### Preenchimento
- **Salve rascunhos** se possível (depende da configuração)
- **Revise as respostas** antes de enviar
- **Mantenha cópias** de arquivos importantes

#### Solução de Problemas
- **Use navegadores atualizados** (Chrome, Firefox, Safari, Edge)
- **Desative bloqueadores** de pop-up se necessário
- **Verifique a conexão** com a internet

---

## Solução de Problemas

### Problemas Comuns para Professores

#### "Nenhum formulário disponível"
**Causa**: Não há formulários no curso ou não estão configurados corretamente
**Solução**:
1. Crie pelo menos um formulário de feedback ou banco de dados
2. Verifique se os formulários estão visíveis para os alunos
3. Certifique-se de que os formulários estão ativos

#### Alunos não conseguem acessar
**Causa**: Problemas de permissão ou configuração
**Solução**:
1. Verifique as permissões do papel "Estudante"
2. Confirme se a atividade está visível
3. Teste com uma conta de aluno

#### Formulários não aparecem na lista
**Causa**: Formulários não estão no mesmo curso ou foram excluídos
**Solução**:
1. Verifique se os formulários ainda existem
2. Confirme se estão no curso correto
3. Recrie a Visão Combinada se necessário

### Problemas Comuns para Alunos

#### "Você não tem permissão para acessar"
**Causa**: Restrições de acesso ou problemas de configuração
**Solução**:
1. Verifique se está logado corretamente
2. Entre em contato com o professor
3. Aguarde se a atividade tem data de abertura futura

#### Erro ao enviar formulários
**Causa**: Problemas de validação ou conexão
**Solução**:
1. Verifique se todos os campos obrigatórios estão preenchidos
2. Tente novamente em alguns minutos
3. Entre em contato com o professor se persistir

#### Formulários não carregam
**Causa**: Problemas de navegador ou conexão
**Solução**:
1. Atualize a página (F5)
2. Tente outro navegador
3. Verifique sua conexão com a internet

---

## Perguntas Frequentes

### Para Professores

**P: Posso editar uma Visão Combinada depois de criada?**
R: Sim! Você pode editar a atividade a qualquer momento para adicionar, remover ou reorganizar formulários.

**P: Os alunos podem ver os formulários individuais?**
R: Sim, os formulários originais continuam disponíveis normalmente. A Visão Combinada é apenas uma forma alternativa de acessá-los.

**P: Posso ver as respostas dos alunos?**
R: Sim! As respostas são salvas nos formulários originais, então você pode acessá-las normalmente através de cada formulário individual.

**P: O plugin funciona com todos os tipos de formulários?**
R: Funciona com feedback, banco de dados, questionários (se instalados) e tarefas. Alguns plugins de terceiros podem não ser compatíveis.

**P: Posso definir uma ordem específica para os formulários?**
R: Sim, a ordem é determinada pela ordem em que você seleciona os formulários ao criar ou editar a atividade.

### Para Alunos

**P: Posso salvar um rascunho e continuar depois?**
R: Depende da configuração de cada formulário individual. Alguns permitem rascunhos, outros não.

**P: O que acontece se eu perder a conexão durante o preenchimento?**
R: Infelizmente, os dados podem ser perdidos. É recomendável preencher em uma sessão contínua ou usar rascunhos quando disponível.

**P: Posso anexar arquivos em qualquer formulário?**
R: Apenas nos formulários que originalmente permitem anexos (como tarefas e bancos de dados).

**P: Como sei se meus dados foram enviados corretamente?**
R: Você receberá uma mensagem de confirmação. Além disso, pode verificar nos formulários originais se suas respostas estão lá.

**P: Posso editar minhas respostas depois de enviar?**
R: Depende da configuração de cada formulário individual. Alguns permitem edição posterior, outros não.

**P: O que fazer se o botão de envio não funcionar?**
R: Verifique se todos os campos obrigatórios estão preenchidos, atualize a página e tente novamente. Se persistir, entre em contato com o professor.

---

## Suporte e Contato

### Para Suporte Técnico
- **Email**: contato@levelsistemas.com.br
- **Website**: http://www.levelsistemas.com.br
- **Desenvolvedor**: José Luiz Neto

### Antes de Pedir Ajuda
1. Verifique se o problema não está listado nesta seção
2. Teste com outro navegador
3. Verifique se o Moodle está atualizado
4. Consulte a documentação do seu Moodle

### Informações Úteis
- **Versão do plugin**: 1.0.0
- **Compatibilidade**: Moodle 4.0+
- **Idiomas**: Português e Inglês
- **Licença**: GNU General Public License v3.0

---

*Este manual foi criado para ajudar você a aproveitar ao máximo o Plugin Visão Combinada. Se encontrar algum erro ou tiver sugestões de melhoria, entre em contato conosco!* 