# Instalação do Plugin Visão Combinada

**Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)**  
**Contato: contato@levelsistemas.com.br**  
**Autor: José Luiz Neto**

## Pré-requisitos

- Moodle 4.0 ou superior
- PHP 7.4 ou superior
- Módulos de formulário disponíveis no curso:
  - mod_feedback (incluído no Moodle)
  - mod_data (incluído no Moodle)
  - mod_questionnaire (opcional, se instalado)

## Instalação

### Método 1: Instalação Manual

1. **Faça backup do seu Moodle** antes de instalar qualquer plugin.

2. **Copie os arquivos:**
   ```bash
   # Navegue até o diretório mod do Moodle
   cd /path/to/moodle/mod/
   
   # Copie a pasta combinedview
   cp -r /path/to/combinedview ./
   ```

3. **Acesse o Moodle como administrador**

4. **Vá para Notificações:**
   - Acesse: Site administration > Notifications
   - O Moodle detectará automaticamente o novo módulo
   - Clique em "Continue" para instalar

5. **Verifique a instalação:**
   - Vá para: Site administration > Plugins > Activity modules
   - Procure por "Combined View" na lista

### Método 2: Via Git (para desenvolvedores)

```bash
cd /path/to/moodle/mod/
git clone https://github.com/seu-usuario/moodle-mod_combinedview.git combinedview
```

## Configuração

### 1. Permissões

Após a instalação, configure as permissões:

1. Vá para: Site administration > Users > Permissions > Define roles
2. Edite os papéis necessários (ex: Student, Teacher)
3. Adicione as seguintes capacidades:
   - `mod/combinedview:view` - Para visualizar a atividade
   - `mod/combinedview:submit` - Para enviar formulários
   - `mod/combinedview:addinstance` - Para criar atividades (apenas professores)

### 2. Criação de Atividade

1. **Ative o modo de edição** no curso
2. **Adicione uma atividade:**
   - Clique em "Add an activity or resource"
   - Selecione "Combined View"
   - Clique em "Add"

3. **Configure a atividade:**
   - **Nome:** Digite um nome para a atividade
   - **Descrição:** Adicione uma descrição (opcional)
   - **Selecionar formulários:** Escolha os formulários que serão combinados
   - **Disponibilidade:** Configure as datas de abertura e fechamento
   - **Outras configurações:** Configure conforme necessário

4. **Salve e retorne ao curso**

## Uso

### Para Professores:

1. **Criar formulários base:**
   - Crie formulários de feedback, data ou questionnaire no curso
   - Certifique-se de que os formulários estão configurados corretamente

2. **Criar Visão Combinada:**
   - Adicione uma nova atividade "Combined View"
   - Selecione os formulários desejados
   - Configure as opções de disponibilidade

### Para Alunos:

1. **Acessar a atividade:**
   - Clique na atividade "Combined View" no curso
   - Todos os formulários selecionados aparecerão em uma única página

2. **Preencher formulários:**
   - Preencha todos os campos necessários
   - Navegue entre os diferentes formulários na mesma página

3. **Enviar:**
   - Clique no botão "Enviar todos os formulários"
   - Aguarde a confirmação de sucesso

## Solução de Problemas

### Erro: "Nenhum formulário disponível"

**Causa:** Não há formulários (feedback, data, questionnaire) no curso.

**Solução:**
1. Crie pelo menos um formulário de feedback ou data no curso
2. Certifique-se de que o formulário está visível para os alunos
3. Tente criar a Visão Combinada novamente

### Erro: "Você não tem permissão para acessar"

**Causa:** Permissões não configuradas corretamente.

**Solução:**
1. Verifique as permissões do papel do usuário
2. Certifique-se de que o usuário tem a capacidade `mod/combinedview:view`
3. Verifique se o usuário tem permissão para acessar os formulários originais

### Erro: "Erro ao enviar os formulários"

**Causa:** Problema no processamento dos dados.

**Solução:**
1. Verifique os logs de erro do Moodle
2. Certifique-se de que todos os campos obrigatórios foram preenchidos
3. Tente novamente ou entre em contato com o administrador

### Plugin não aparece na lista de atividades

**Causa:** Instalação incompleta ou arquivos corrompidos.

**Solução:**
1. Verifique se todos os arquivos foram copiados corretamente
2. Acesse as notificações do Moodle para forçar a detecção
3. Verifique as permissões dos arquivos (deve ser 644 para arquivos, 755 para diretórios)

## Manutenção

### Atualizações

Para atualizar o plugin:

1. Faça backup dos dados
2. Substitua os arquivos antigos pelos novos
3. Acesse as notificações do Moodle
4. Siga as instruções de atualização

### Desinstalação

Para remover o plugin:

1. **Remova as atividades:**
   - Delete todas as atividades "Combined View" dos cursos
   - Ou faça backup dos cursos primeiro

2. **Desinstale o plugin:**
   - Vá para: Site administration > Plugins > Activity modules
   - Clique em "Uninstall" ao lado de "Combined View"

3. **Remova os arquivos:**
   ```bash
   rm -rf /path/to/moodle/mod/combinedview
   ```

## Suporte

Para suporte técnico:

1. Verifique a documentação no arquivo README.md
2. Consulte os logs de erro do Moodle
3. Entre em contato com o desenvolvedor

## Logs de Atividade

O plugin registra as seguintes atividades:

- **Visualização:** Quando um usuário acessa a atividade
- **Submissão:** Quando um usuário envia todos os formulários

Para visualizar os logs:
- Vá para: Reports > Logs
- Filtre por "Combined View" no módulo 