<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

use local_avaliador\models\userlinks;
use local_avaliador\utils;

defined('MOODLE_INTERNAL') || die();

/**
 * Função para estender o menu de "Usuários" na seção "Permissões" dentro de "Administração do site".
 */
function local_avaliador_extend_navigation_course(
    navigation_node $parentnode,
    stdClass $course,
    context_course $context
) {
    if (userlinks::userLoggedHasLink() > 0) {
        $url = new moodle_url('/local/avaliador/index.php', ['p' => 'home', 'id' => $course->id]);
        $parentnode->add(get_string('pluginname', 'local_avaliador'), $url);
    }
}

function local_avaliador_before_footer() {
    echo '<!-- Desenvolvido por Level Sistemas - Contato: contato@levelsistemas.com.br -->';
}

function local_avaliador_extend_navigation(global_navigation $nav) {
    local_avaliador_before_footer();
}
