<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

use local_avaliador\pages\home;

require_once('../../config.php');

global $PAGE, $OUTPUT;

require_login(); // Garante que o usuário está logado

$courseid = required_param('id', PARAM_INT);

$course = $DB->get_record('course', ['id' => $courseid], 'fullname', MUST_EXIST);

$pageHome = new home($USER, $courseid);

// Define o contexto e a URL da página
$context = context_system::instance();
$PAGE->set_url(new moodle_url('/local/avaliador/index.php', ['id' => $courseid]));
$PAGE->set_context($context);
$PAGE->set_title($course->fullname.": ". get_string('meusavaliadores', 'local_avaliador'));
$PAGE->set_heading($course->fullname.": ". get_string('meusavaliadores', 'local_avaliador'));

// Renderiza a página
echo $OUTPUT->header();

echo $pageHome->renderTable();

echo $OUTPUT->footer();

echo $pageHome->renderStyle();

