<?php
require_once('../../config.php');
require_once($CFG->libdir.'/adminlib.php');
require_once($CFG->libdir.'/formslib.php');

require_login();
require_capability('moodle/site:config', context_system::instance());

$PAGE->set_context(context_system::instance());
$PAGE->set_url(new moodle_url('/local/avaliador/gestores.php'));
$PAGE->set_pagelayout('admin');
$PAGE->set_title(get_string('associargestores', 'local_avaliador'));
$PAGE->set_heading(get_string('associargestores', 'local_avaliador'));

// Formulário para selecionar gestores
class gestores_form extends moodleform {
    public function definition() {
        global $DB;
        
        $mform = $this->_form;
        
        $users = $DB->get_records_sql("
            SELECT u.id, CONCAT(u.firstname, ' ', u.lastname, ' [', u.email, ']') as name
            FROM {local_avaliador_users_links} l
            JOIN {user} u ON l.userid = u.id
            WHERE u.deleted = 0 AND u.suspended = 0
            ORDER BY u.firstname ASC
        ");
        
        $useroptions = array();
        foreach ($users as $user) {
            $useroptions[$user->id] = $user->name;
        }
        
        // Busca gestores atuais
        $current_gestores = get_config('local_avaliador', 'gestaoid');
        $current_gestores = $current_gestores ? explode(',', $current_gestores) : array();
        
        // Adiciona o campo de seleção múltipla
        $mform->addElement('select', 'gestores', get_string('gestaoid', 'local_avaliador'), $useroptions, array('multiple' => 'multiple', 'size' => 20));
        $mform->setType('gestores', PARAM_INT);
        $mform->setDefault('gestores', $current_gestores);
        
        // Botões
        $this->add_action_buttons();
    }
}

$form = new gestores_form();

if ($form->is_cancelled()) {
    redirect(new moodle_url('/admin/settings.php', array('section' => 'local_avaliador')));
} else if ($data = $form->get_data()) {
    // Salva os gestores selecionados
    $gestores = implode(',', $data->gestores);
    set_config('gestaoid', $gestores, 'local_avaliador');
    
    redirect(new moodle_url('/admin/settings.php', array('section' => 'local_avaliador')));
}

echo $OUTPUT->header();
$form->display();
echo $OUTPUT->footer(); 