<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

namespace local_avaliador;

defined('MOODLE_INTERNAL') || die();

class db {

    // Função para carregar uma sessão específica
    public static function get_section($sectionid) {
        global $DB;
        return $DB->get_record('course_sections', ['id' => $sectionid]);
    }

    // Função para consultar atividades de uma sessão
    public static function get_activities($sectionid, $userid) {
        global $DB;
        $sql = "SELECT cm.id AS cmid, cm.module, cmc.completionstate, cm.instance, m.name AS modulename
                FROM {course_modules} cm
                JOIN {modules} m ON cm.module = m.id
                LEFT JOIN {course_modules_completion} cmc ON cm.id = cmc.coursemoduleid AND cmc.userid = :userid
                WHERE cm.section = :sectionid";
        return $DB->get_records_sql($sql, [
            'sectionid' => $sectionid,
            'userid' => $userid,
        ]);
    }

    // Função para buscar tentativas de quiz de um usuário
    public static function get_quiz_attempts($quizid, $userid) {
        global $DB;
        return $DB->get_records('quiz_attempts', ['quiz' => $quizid, 'userid' => $userid, 'state' => 'finished']);
    }

    // Função para buscar perguntas e respostas de quizzes
    public static function get_quiz_responses($attemptid) {
        global $DB;
        return $DB->get_records('question_attempts', ['questionusageid' => $attemptid]);
    }

    // Função para buscar os passos de respostas de perguntas em quizzes
    public static function get_question_steps($questionid) {
        global $DB;
        return $DB->get_records('question_attempt_steps', ['questionattemptid' => $questionid]);
    }

    // Função para buscar respostas de feedbacks
    public static function get_feedback_responses($feedbackid, $userid) {
        global $DB;
        $feedbackcompleted = $DB->get_record('feedback_completed', ['feedback' => $feedbackid, 'userid' => $userid]);
        $items = $DB->get_records('feedback_item', ['feedback' => $feedbackid], 'position');
        return [$feedbackcompleted, $items];
    }

    // Função para buscar arquivos enviados em uma submissão de tarefa (assign)
    public static function get_assign_files($submissionid) {
        global $DB;
        return $DB->get_records('files', [
            'component' => 'assignsubmission_file',
            'filearea' => 'submission_files',
            'itemid' => $submissionid
        ]);
    }

    // Função para buscar a submissão de uma tarefa (assign)
    public static function get_assign_submission($assignid, $userid) {
        global $DB;
        return $DB->get_record('assign_submission', ['assignment' => $assignid, 'userid' => $userid]);
    }

    // Função para buscar o estado de conclusão de uma atividade
    public static function get_activity_completion($cmid, $userid) {
        global $DB;
        return $DB->get_record('course_modules_completion', ['coursemoduleid' => $cmid, 'userid' => $userid]);
    }

    public static function get_activity_title($modulename, $instance) {
        global $DB;
        return $DB->get_field($modulename, 'name', ['id' => $instance]);
    }
    
    // Função para buscar avaliadores de um usuário
    public static function get_avaliadores($userid) {
        global $DB;
        $sql = "SELECT u.id, u.firstname, u.lastname,
                    u.firstnamephonetic, u.lastnamephonetic, 
                    u.middlename, u.alternatename
                FROM {local_avaliador_users_links} l
                JOIN {user} u ON l.avaliadorid = u.id
                WHERE l.userid = :userid";
        return $DB->get_records_sql($sql, ['userid' => $userid]);
    }

    // Função para buscar as seções de um curso
    public static function get_sections($courseid) {
        global $DB;
        $sql = "SELECT cs.id, cs.name, cs.section
                FROM {course_sections} cs
                JOIN {course_modules} cm ON cm.section = cs.id
                JOIN {modules} m ON cm.module = m.id
                WHERE cs.course = :courseid
                  AND m.name IN ('feedback', 'assign') 
                  AND cs.name LIKE '%Missão%'
                ORDER BY cs.section";
        // utils::dd($sql);
        return $DB->get_records_sql($sql, ['courseid' => $courseid]);
    }
}
