/**
 * AMD module used when rearranging a custom certificate.
 *
 * @module     mod_customcert/rearrange-area
 * @copyright  2016 Mark Nelson <markn@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_customcert/rearrange-area",["jquery","core/yui","core/fragment","mod_customcert/dialogue","core/notification","core/str","core/templates","core/ajax"],(function($,Y,fragment,Dialogue,notification,str,template,ajax){var RearrangeArea=function(selector){this._node=$(selector),this._setEvents()};return RearrangeArea.prototype.CUSTOMCERT_REF_POINT_TOPLEFT=0,RearrangeArea.prototype.CUSTOMCERT_REF_POINT_TOPCENTER=1,RearrangeArea.prototype.CUSTOMCERT_REF_POINT_TOPRIGHT=2,RearrangeArea.prototype.PIXELSINMM=3.779527559055,RearrangeArea.prototype._setEvents=function(){this._node.on("click",".element",this._editElement.bind(this))},RearrangeArea.prototype._editElement=function(event){var elementid=event.currentTarget.id.substr(8),contextid=this._node.attr("data-contextid"),params={elementid:elementid};fragment.loadFragment("mod_customcert","editelement",contextid,params).done(function(html,js){str.get_string("editelement","mod_customcert").done(function(title){Y.use("moodle-core-formchangechecker",function(){new Dialogue(title,"<div id='elementcontent'></div>",this._editElementDialogueConfig.bind(this,elementid,html,js),void 0,!0)}.bind(this))}.bind(this))}.bind(this)).fail(notification.exception)},RearrangeArea.prototype._editElementDialogueConfig=function(elementid,html,js,popup){template.replaceNode("#elementcontent",html,js),this._setPositionInForm(elementid);var body=$(popup.getContent());body.on("click","#id_submitbutton",function(e){M.core_formchangechecker.reset_form_dirty_state(),this._saveElement(elementid).then(function(){this._getElementHTML(elementid).done(function(html){var elementNode=this._node.find("#element-"+elementid),refpoint=parseInt($("#id_refpoint").val()),refpointClass="";refpoint==this.CUSTOMCERT_REF_POINT_TOPLEFT?refpointClass="refpoint-left":refpoint==this.CUSTOMCERT_REF_POINT_TOPCENTER?refpointClass="refpoint-center":refpoint==this.CUSTOMCERT_REF_POINT_TOPRIGHT&&(refpointClass="refpoint-right"),elementNode.empty().append(html),elementNode.removeClass(),elementNode.addClass("element "+refpointClass),elementNode.attr("data-refpoint",refpoint);var posx=$("#editelementform #id_posx").val(),posy=$("#editelementform #id_posy").val();this._setPosition(elementid,refpoint,posx,posy),popup.close()}.bind(this))}.bind(this)).fail(notification.exception),e.preventDefault()}.bind(this)),body.on("click","#id_cancel",(function(e){popup.close(),e.preventDefault()}))},RearrangeArea.prototype._setPosition=function(elementid,refpoint,posx,posy){var element=Y.one("#element-"+elementid);posx=Y.one("#pdf").getX()+posx*this.PIXELSINMM,posy=Y.one("#pdf").getY()+posy*this.PIXELSINMM;var nodewidth=parseFloat(element.getComputedStyle("width")),maxwidth=element.width*this.PIXELSINMM;switch(maxwidth&&nodewidth>maxwidth&&(nodewidth=maxwidth),refpoint){case this.CUSTOMCERT_REF_POINT_TOPCENTER:posx-=nodewidth/2;break;case this.CUSTOMCERT_REF_POINT_TOPRIGHT:posx=posx-nodewidth+2}element.setX(posx),element.setY(posy)},RearrangeArea.prototype._setPositionInForm=function(elementid){var posxelement=$("#editelementform #id_posx"),posyelement=$("#editelementform #id_posy");if(posxelement.length&&posyelement.length){var element=Y.one("#element-"+elementid),posx=element.getX()-Y.one("#pdf").getX(),posy=element.getY()-Y.one("#pdf").getY(),refpoint=parseInt(element.getData("refpoint")),nodewidth=parseFloat(element.getComputedStyle("width"));switch(refpoint){case this.CUSTOMCERT_REF_POINT_TOPCENTER:posx+=nodewidth/2;break;case this.CUSTOMCERT_REF_POINT_TOPRIGHT:posx+=nodewidth}posx=Math.round(parseFloat(posx/this.PIXELSINMM)),posy=Math.round(parseFloat(posy/this.PIXELSINMM)),posxelement.val(posx),posyelement.val(posy)}},RearrangeArea.prototype._getElementHTML=function(elementid){var templateid=this._node.attr("data-templateid");return ajax.call([{methodname:"mod_customcert_get_element_html",args:{templateid:templateid,elementid:elementid}}])[0]},RearrangeArea.prototype._saveElement=function(elementid){var templateid=this._node.attr("data-templateid"),inputs=$("#editelementform").serializeArray();return ajax.call([{methodname:"mod_customcert_save_element",args:{templateid:templateid,elementid:elementid,values:inputs}}])[0]},{init:function(selector){new RearrangeArea(selector)}}}));

//# sourceMappingURL=rearrange-area.min.js.map