<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

require_once('../../config.php');
require_once('forms.php');
require_login();

$context = context_system::instance();
require_capability('moodle/site:config', $context);

$PAGE->set_url(new moodle_url('/local/avaliador/userslinks.php'));
$PAGE->set_context($context);
$PAGE->set_title(get_string('userlinks', 'local_avaliador'));
$PAGE->set_heading(get_string('userlinks', 'local_avaliador'));

// Obtém o ID do usuário principal (se existe)
$userid = optional_param('userid', 0, PARAM_INT);
$associated_users = [];

if ($userid) {
    // Consulta os usuários associados ao "Usuário Principal"
    $associated_users = $DB->get_records('local_avaliador_users_links', ['userid' => $userid], '', 'avaliadorid');
    $associated_users = array_keys($associated_users);  // Obter apenas os IDs dos usuários
}

$action = optional_param('action', '', PARAM_ALPHA);

if ($action === 'delete' && $userid) {
    // Exclui os vínculos do "Usuário Principal"
    $DB->delete_records('local_avaliador_users_links', ['userid' => $userid]);

    // Redireciona para a página de configurações com uma mensagem de sucesso
    redirect(new moodle_url('/admin/settings.php?section=local_avaliador'), get_string('deleted', 'local_avaliador'));
}

// Instancia o formulário, passando os dados do usuário principal e os usuários associados
$mform = new user_link_form(null, ['associated_users' => $associated_users, 'userid' => $userid]);

if ($mform->is_cancelled()) {
    // Redireciona para a página principal ao cancelar
    redirect(new moodle_url('/admin/settings.php?section=local_avaliador'));
} else if ($data = $mform->get_data()) {
    // Remove os vínculos antigos para o "Usuário Principal"
    $DB->delete_records('local_avaliador_users_links', ['userid' => $data->userid]);

    // Insere os novos vínculos
    foreach ($data->avaliadorid as $avaliadorid) {
        $record = new stdClass();
        $record->userid = $data->userid;
        $record->avaliadorid = $avaliadorid;
        $record->timecreated = time();
        $DB->insert_record('local_avaliador_users_links', $record);
    }

    // Redireciona para a página principal após salvar
    redirect(new moodle_url('/admin/settings.php?section=local_avaliador'), get_string('success', 'local_avaliador'));
}

echo $OUTPUT->header();
$mform->display();
echo $OUTPUT->footer();
