<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

use mod_customcert\admin_setting_link;

defined('MOODLE_INTERNAL') || die();

if ($hassiteconfig) {
    // Adiciona a página de configurações ao menu de Usuários
    $settings = new admin_settingpage('local_avaliador', get_string('pluginnamesettings', 'local_avaliador'));
    $ADMIN->add('roles', $settings);

    if ($ADMIN->fulltree) {
        // Consulta para obter o nome do curso e o nome do feedback juntos
        // $sql = "SELECT f.id, CONCAT(c.fullname, ' - ', f.name) AS coursename_feedbackname
        $sql = "SELECT f.id, CONCAT(c.fullname, ' - ', f.name) AS coursename_feedbackname
                FROM {feedback} f
                JOIN {course} c ON f.course = c.id";

        $feedbacks = $DB->get_records_sql_menu($sql);

        // Adiciona um campo de seleção para escolher uma pesquisa (feedback)
        $settings->add(new admin_setting_configselect(
            'local_avaliador/feedbackid',
            get_string('feedbackid', 'local_avaliador'),
            get_string('feedbackid_desc', 'local_avaliador'),
            '',
            $feedbacks
        ));
        
        $settings->add(new admin_setting_configtextarea(
            'local_avaliador/answerhighlight',
            get_string('answerhighlight', 'local_avaliador'),
            get_string('answerhighlight_desc', 'local_avaliador'),
            '', //'Missão escolhida\nDescreva a ação',
        ));
        
        $settings->add(new admin_setting_configtextarea(
            'local_avaliador/answerhide',
            get_string('answerhide', 'local_avaliador'),
            get_string('answerhide_desc', 'local_avaliador'),
            '', //'Missão escolhida\nDescreva a ação',
        ));


        // Adiciona um link para a página de associação de usuários
        $settings->add(new admin_setting_link(
            'linkassociar',
            get_string('associarusuarios', 'local_avaliador'),
            '<br />',
            get_string('associarusuariosnew', 'local_avaliador'),
            new moodle_url('/local/avaliador/userslinks.php'),
            null
        ));

        // Consulta os dados da tabela de links de usuários
        global $DB;
        $vinculos = $DB->get_records_sql("
        SELECT l.userid, CONCAT(CONCAT(u1.firstname, ' ', u1.lastname),' [', u1.email, ']') AS principal, GROUP_CONCAT(CONCAT(CONCAT(u2.firstname, ' ', u2.lastname),' [', u2.email, ']') SEPARATOR ',') AS associados
        FROM {local_avaliador_users_links} l
        JOIN {user} u1 ON l.userid = u1.id
        JOIN {user} u2 ON l.avaliadorid = u2.id
        GROUP BY l.userid
        ORDER BY u1.firstname ASC
        ");

        $htmloutput = '';
        if ($vinculos) {
            // Exibe os dados formatados
            $htmloutput .= '<a href="javascript:void(0);" ';
            $htmloutput .= ' onclick="document.getElementById(\'local_avaliador-div-userslinks\').style.display = \'inline-block\'; ';
            $htmloutput .= ' this.style.display = \'none\';">Visualizar todos</a> ';
            $htmloutput .= '<div id="local_avaliador-div-userslinks" style="display:none">';

            foreach ($vinculos as $vinculo) {
                $editlink = html_writer::link(new moodle_url('/local/avaliador/userslinks.php', ['userid' => $vinculo->userid]), get_string('editar', 'local_avaliador'));
                $deletelink = html_writer::link(new moodle_url('/local/avaliador/userslinks.php', ['userid' => $vinculo->userid, 'action' => 'delete']), get_string('excluir', 'local_avaliador'), ['onclick' => 'return confirm("Tem certeza que deseja excluir este vínculo?");']);

                $htmloutput .= '<b>' . $vinculo->principal . ': </b> ' . $editlink . ' | ' . $deletelink;
                $htmloutput .= '<ul>';
                foreach (explode(",", $vinculo->associados) as $associado) {
                    $htmloutput .= '<li>' . $associado . '</li> ';
                }
                $htmloutput .= '</ul>';
            }
            $htmloutput .= '</div><br /><br />';
        } else {
            $htmloutput .= '<p>' . get_string('nouvinculo', 'local_avaliador') . '</p>';
        }

        $settings->add(new admin_setting_description(
            'listavinculos',
            get_string('usuariosvinculados', 'local_avaliador'),
            $htmloutput
        ));
    }
}
