<?php

use local_avaliador\utils;

require_once('../../config.php');
global $DB, $CFG;

// ID da tarefa e do usuário são passados via URL (GET)
$id = required_param('id', PARAM_INT);
$userid = required_param('userid', PARAM_INT);

// Consultar a tabela de arquivos
$file = $DB->get_record_sql("
    SELECT f.*
    FROM {files} f
    WHERE f.id = :id
      AND f.component = 'assignsubmission_file'
      AND f.filearea = 'submission_files'
      AND f.filename <> '.'",
    ['id' => $id, 'userid' => $userid]
);

// Certifique-se de que o arquivo foi encontrado
if ($file) {
    $fs = get_file_storage();
    $storedfile = $fs->get_file(
        $file->contextid,
        $file->component,
        $file->filearea,
        $file->itemid,
        $file->filepath,
        $file->filename
    );

    if ($storedfile) {
        // Recuperar o conteúdo do arquivo diretamente
        $filecontent = $storedfile->get_content();
        $mimetype = $storedfile->get_mimetype();

        // Definir os cabeçalhos corretos para servir a imagem
        header('Content-Type: ' . $mimetype);
        header('Content-Disposition: inline; filename="' . $storedfile->get_filename() . '"');
        header('Content-Length: ' . $storedfile->get_filesize());

        // Exibir o conteúdo da imagem
        echo $filecontent;
    } else {
        echo "Arquivo não encontrado.";
    }
} else {
    echo "Nenhum arquivo foi submetido por este usuário.";
}
