<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

require_once("$CFG->libdir/formslib.php");

class user_link_form extends moodleform
{
    public function definition()
    {
        $mform = $this->_form;
        $data = $this->_customdata;

        $associated_users = $data['associated_users'] ?? [];
        $userid = $data['userid'] ?? 0;

        $showAvaliadores = true;
        if ($userid) {
            $this->add_hidden_user_field($mform, $userid);
        } else {
            $showAvaliadores = $this->add_user_selection_field($mform);
        }

        if ($showAvaliadores) {
            $this->add_associated_users_field($mform, $associated_users);
            $this->add_action_buttons();
        } else {
            $mform->addElement('cancel');
        }
    }

    /**
     * Adiciona o campo de usuário principal como campo oculto e congelado.
     *
     * @param MoodleQuickForm $mform
     * @param int $userid
     */
    private function add_hidden_user_field($mform, $userid)
    {
        $mform->addElement('hidden', 'userid', get_string('usuarioprincipal', 'local_avaliador'));
        $mform->setDefault('userid', $userid);

        $userName = $this->get_user_name($userid);
        $mform->addElement('static', 'userid-fake', get_string('usuarioprincipal', 'local_avaliador'), $userid);
        $mform->setDefault('userid-fake', $userName);
        $mform->freeze('userid-fake');
    }

    /**
     * Adiciona o campo de seleção de usuário principal, baseado no papel configurado.
     *
     * @param MoodleQuickForm $mform
     * @return bool
     */
    private function add_user_selection_field($mform)
    {
        $role_default = get_config('local_avaliador', 'role_default');
        $users = $this->get_users_by_role($role_default);

        if (empty($users)) {
            $mform->addElement('static', 'userid', get_string('selectuser', 'local_avaliador'), '<i style="color: red">Nenhum usuário disponível para o papel selecionado.</i>');
            return false;
        }

        $mform->addElement('select', 'userid', get_string('selectuser', 'local_avaliador'), $users);
        $mform->setType('userid', PARAM_INT);
        $mform->addRule('userid', null, 'required', null, 'client');
        return true;
    }

    /**
     * Adiciona o campo para selecionar usuários associados (avaliadores).
     *
     * @param MoodleQuickForm $mform
     * @param array $associated_users
     */
    private function add_associated_users_field($mform, $associated_users)
    {
        $mform->addElement('select', 'avaliadorid', get_string('selectlinkedusers', 'local_avaliador'), $this->get_users(), ['multiple' => 'multiple', 'size' => 15]);
        $mform->setType('avaliadorid', PARAM_INT);
        $mform->addRule('avaliadorid', null, 'required', null, 'client');
        $mform->setDefault('avaliadorid', $associated_users);
    }

    /**
     * Obtém o nome completo de um usuário pelo ID.
     *
     * @param int $userid
     * @return string
     */
    private function get_user_name($userid)
    {
        global $DB;
        $user = $DB->get_record('user', ['id' => $userid], 'firstname, lastname');

        return $user ? "{$user->firstname} {$user->lastname}" : "Usuário não encontrado.";
    }

    /**
     * Obtém todos os usuários do sistema, exceto os já vinculados.
     *
     * @return array
     */
    private function get_users()
    {
        global $DB;

        $sql = "SELECT u.id, CONCAT(u.firstname, ' ', u.lastname) AS name
                FROM {user} u
                LEFT JOIN {local_avaliador_users_links} l ON l.userid = u.id
                WHERE l.userid IS NULL
                ORDER BY u.firstname";

        return $DB->get_records_sql_menu($sql);
    }

    /**
     * Obtém usuários baseados em um papel específico, excluindo os já vinculados.
     *
     * @param int $roleId
     * @return array
     */
    private function get_users_by_role($roleId)
    {
        global $DB;

        $sql = "SELECT u.id, CONCAT(u.firstname, ' ', u.lastname) AS name
                FROM {user} u
                JOIN {role_assignments} ra ON ra.userid = u.id
                LEFT JOIN {local_avaliador_users_links} l ON l.userid = u.id
                WHERE  l.userid IS NULL
                ORDER BY u.firstname";

        return $DB->get_records_sql_menu($sql);
    }
}
