<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

namespace local_avaliador;

use stdClass;

define('FEEDBACK_MULTICHOICE_TYPE_SEP', '>>>>>');
define('FEEDBACK_MULTICHOICE_LINE_SEP', '|');
define('FEEDBACK_MULTICHOICE_ADJUST_SEP', '<<<<<');
define('FEEDBACK_MULTICHOICE_IGNOREEMPTY', 'i');
define('FEEDBACK_MULTICHOICE_HIDENOSELECT', 'h');

class utils {
    
    public static function item_get_options($item) {
        $info = self::item_get_info($item);
        $presentation = explode (FEEDBACK_MULTICHOICE_LINE_SEP, $info->presentation);
        $options = array();
        foreach ($presentation as $idx => $optiontext) {
            $options[$idx + 1] = format_text($optiontext, FORMAT_HTML, array('noclean' => true, 'para' => false));
        }
        return $options;
    }
    
    public static function item_get_info($item) {
        $presentation = empty($item->presentation) ? '' : $item->presentation;

        $info = new stdClass();
        //check the subtype of the multichoice
        //it can be check(c), radio(r) or dropdown(d)
        $info->subtype = '';
        $info->presentation = '';
        $info->horizontal = false;

        $parts = explode(FEEDBACK_MULTICHOICE_TYPE_SEP, $item->presentation);
        $info->subtype = $parts[0];
        if (count($parts) > 1) {
            $info->presentation = $parts[1];
        }
        if (!isset($info->subtype)) {
            $info->subtype = 'r';
        }

        if ($info->subtype != 'd') {
            $parts = explode(FEEDBACK_MULTICHOICE_ADJUST_SEP, $info->presentation);
            $info->presentation = $parts[0];
            if (count($parts) > 1) {
                $info->horizontal = $parts[1];
            }
            if (isset($info->horizontal) AND $info->horizontal == 1) {
                $info->horizontal = true;
            } else {
                $info->horizontal = false;
            }
        }
        return $info;
    }

    public static function in_array_partial($texto, $array) {
        $texto = strtolower(trim($texto));
        foreach ($array as $palavra) {
            $palavra = strtolower(trim($palavra));
            if (empty($palavra)) continue;
            
            if (stripos($texto, $palavra) !== false) {
                return true;
            }
        }
        return false;
    }
    
    public static function indetifyAndConvertLinksInText($texto) {
        // Expressão regular para identificar URLs
        $regex = '/(http|https|ftp|ftps):\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/';
        
        // Substituir URLs pela versão clicável
        $textoComLinks = preg_replace($regex, '<a href="$0" target="_blank">$0</a>', $texto);
        
        return $textoComLinks;
    }
    
    public static function dump(...$vars)
    {
        echo "<pre>";
        foreach ($vars as $var) {
            print_r($var);
            echo "<hr />";
        }
        echo "</pre>";
    }
    
    public static function dd(...$vars)
    {
        self::dump($vars);
        die();
    }
}
