<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

namespace local_avaliador\pages;

use context_system;
use html_writer;
use local_avaliador\db;
use local_avaliador\models\useranswers;
use local_avaliador\models\userlinks;
use local_avaliador\utils;
use moodle_url;

class home
{
    private $user;
    private $courseid;
    private $course;
    private $avaliadores;
    private $sections;

    public function __construct($user, $courseid)
    {
        $this->user = $user;
        $this->courseid = $courseid;
        $this->loadCourse();
        $this->checkAccess();
        $this->loadAvaliadores();
        $this->loadSections();
    }

    private function loadCourse()
    {
        global $DB;
        if (!$this->course = $DB->get_record('course', ['id' => $this->courseid])) {
            redirect("/");
        }
    }

    private function checkAccess()
    {
        if (userlinks::userLoggedHasLink() <= 0 || !can_access_course($this->course, $this->user)) {
            redirect("/");
            $return .= "O usuário não tem acesso ao curso.";
            echo $return;
            exit;
        }
    }

    private function loadAvaliadores()
    {
        $this->avaliadores = db::get_avaliadores($this->user->id);
    }

    private function loadSections()
    {
        $this->sections = db::get_sections($this->courseid);
    }

    public static function renderStyle()
    {
        $return = "<style scoped>";
        $return .= "
        .local_avaliador_table{
            width: 100%;
        }

        .local_avaliador_table th{
            border: 1px solid #000;
        }

        .local_avaliador_table td{
            border: 1px solid #000;
            text-align: center;
        }
            
        .local_avaliador_table tr:nth-child(odd) {
            background-color: #EEE;
        }
        ";
        $return .= "</style>";
        return $return;
    }

    public function renderTable()
    {
        $return = "";
        if ($this->avaliadores) {
            $return .= "<table class='local_avaliador_table'>";
            foreach ($this->avaliadores as $avaliador) {
                $return .= "<tr>";
                $return .= "<th>" . fullname($avaliador) . "</th>";
                $return .= $this->renderSections($avaliador);
                $return .= "</tr>";
            }
            $return .= "</table>";
        } else {
            $return .= html_writer::tag('p', get_string('noavaliadores', 'local_avaliador'));
        }
        return $return;
    }

    private function renderSections($avaliador)
    {
        $return = "";
        if ($this->sections) {
            foreach ($this->sections as $section) {
                $return .= "<td>";
                
                $return .= format_string($section->name ? $section->name : "Sessão " . $section->section);
                $return .= "<br />";
                
                if ($useranswer = useranswers::hasUserAvaliadorAnswer($section->id, $avaliador->id)) {
                    $return .= html_writer::link(
                        new moodle_url("/local/avaliador/answer.php", [
                            'courseid' => $this->courseid,
                            'avaliadorid' => $avaliador->id,
                            'sectionid' => $section->id,
                            'useranswerid' => $useranswer,
                        ]),
                        "<b style='color:green'>Avaliado ✅</b>"
                    );
                } else {
                    $return .= html_writer::link(
                        new moodle_url("/local/avaliador/answer.php", [
                            'courseid' => $this->courseid,
                            'avaliadorid' => $avaliador->id,
                            'sectionid' => $section->id,
                        ]),
                        "Avaliar ◻️"
                    );
                }
                
                // $return .= $sectionName;

                // Renderizar atividades
                // $return .= $this->renderActivities($section, $avaliador);
                $return .= "</td>";
            }
        } else {
            $return .= html_writer::tag('p', get_string('nosections', 'local_avaliador'));
        }
        return $return;
    }

    private function renderActivities($section, $avaliador)
    {
        $return = "";
        $activities = db::get_activities($section->id, $avaliador->id);
        if ($activities) {
            $return .= "<br />";
            $returnArray = [];
            foreach ($activities as $activity) {
                if (in_array($activity->modulename, ['assign', 'feedback'])) {
                    $activity_title = db::get_activity_title($activity->modulename, $activity->instance);
                    $completionstatus = ($activity->completionstate == 1) ? " style='color:green'" : " style='color:red'";
                    // $return .= "<span $completionstatus>$activity_title<br />";
                    $returnArray[$activity_title] = "<span $completionstatus>$activity_title<br />";
                }
            }
            ksort($returnArray);
            $return .= implode("", $returnArray);
        } else {
            $return .= html_writer::tag('p', get_string('noactivities', 'local_avaliador'));
        }
        return $return;
    }

    public function renderPage()
    {
        $return = "";
        global $PAGE, $OUTPUT;

        // Define o contexto e a URL da página
        $context = context_system::instance();
        $PAGE->set_url(new moodle_url('/local/avaliador/meus_avaliadores.php', ['courseid' => $this->courseid]));
        $PAGE->set_context($context);
        $PAGE->set_title(get_string('meusavaliadores', 'local_avaliador'));
        $PAGE->set_heading(get_string('meusavaliadores', 'local_avaliador'));

        // Cabeçalho da página
        $return .= $OUTPUT->header();

        // Tabela de avaliadores
        $return .= $this->renderTable();

        // Rodapé da página
        $return .= $OUTPUT->footer();

        // Estilo da página
        $return .= $this->renderStyle();

        // Exibir todo o conteúdo
        echo $return;
    }
}
