<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

namespace local_avaliador\pages;

use moodle_url;
use html_writer;
use local_avaliador\db;
use local_avaliador\utils;

class answer
{
    private $sectionid;
    private $userid;
    private $courseid;
    private $section;
    private $activities;

    public function __construct($sectionid, $userid, $courseid)
    {
        $this->sectionid = $sectionid;
        $this->userid = $userid;
        $this->courseid = $courseid;
        $this->loadSection();
        $this->loadActivities();
    }

    private function loadSection()
    {
        $this->section = db::get_section($this->sectionid);
        if (!$this->section) {
            redirect("/");
        }
    }

    private function loadActivities()
    {
        $this->activities = db::get_activities($this->sectionid, $this->userid);
    }

    public function renderPage()
    {
        $return = "";

        $return .= $this->renderActivitiesTable();

        if (empty($this->activities)) {
            $return .= html_writer::tag('p', 'Nenhuma atividade encontrada para essa sessão.');
        }

        echo $return;
    }

    private function renderActivitiesTable()
    {
        $return = "";

        if ($this->activities) {
            // $return .= "<table class='local_avaliador_table'>";
            foreach ($this->activities as $activity) {
                $completion = db::get_activity_completion($activity->cmid, $this->userid);

                if ($completion && $completion->completionstate == 1) {
                    $return .= $this->renderActivityContent($activity);
                }
            }
            // $return .= "</table>";
        }

        return $return;
    }

    private function renderActivityContent($activity)
    {
        global $DB, $CFG;

        $return = "";

        switch ($activity->modulename) {
            case 'assign':
                $submission = db::get_assign_submission($activity->instance, $this->userid);
                if ($submission) {
                    $files = db::get_assign_files($submission->id);
                    $return .= "<table class='local_avaliador_table'>";
                    $return .= "<tr>";
                    $qtd = 0;
                    $qtdColumns = 3;
                    foreach ($files as $file) {
                        if ($file->filename == ".") {
                            continue;
                        }
                        if ($qtd % $qtdColumns == 0) {
                            $return .= "</tr><tr>";
                            // $return .= "";
                        }
                        $qtd++;
                        $return .= "<td style='width:" . (100 / $qtdColumns) . "%'>";

                        $filepath = $CFG->wwwroot . '/local/avaliador/getfile.php?id=' . $file->id . '&userid=' . $file->userid;
                        // utils::dd($storedfile);

                        switch ($file->mimetype) {
                            case 'image/jpeg':
                                $return .= "<a href='$filepath' target='_blank'>";
                                $return .= "<img src='$filepath' style='max-width: 100%' />";
                                $return .= "</a>";
                                break;
                            case 'video/mp4':
                                $return .= "<video width='100%' height='240' controls>";
                                $return .= "<source src=$filepath type='video/mp4'>";
                                $return .= "Seu browser não suporte arquivos de vídeo.";
                                $return .= "</video>";
                                $return .= "<br /><a href='$filepath' target='_blank'>" . $file->source . "</a>";
                                break;

                            default:
                                // $return.=$file->mimetype;
                                $return .= html_writer::tag('p', html_writer::link($filepath, $file->filename, ["target" => "_blank"]));
                                break;
                        }
                        $return .= "</td>";
                    }

                    $return .= "</tr>";
                    $return .= "</table>";
                    $return .= "<hr />";
                }
                break;

            case 'feedback':

                $answerhighlight = explode(PHP_EOL, get_config('local_avaliador', 'answerhighlight') ?? "") ?? [];
                $answerhide = explode(PHP_EOL, get_config('local_avaliador', 'answerhide') ?? "") ?? [];

                [$completed, $items] = db::get_feedback_responses($activity->instance, $this->userid);
                $return .= "<table class='local_avaliador_table_answer'>";
                foreach ($items as $item) {
                    $cssAditional = "";
                    if (utils::in_array_partial($item->name, $answerhighlight)) {
                        $cssAditional = " class='local_avaliador_highlight'";
                    }

                    if (utils::in_array_partial($item->name, $answerhide)) {
                        $cssAditional = " class='local_avaliador_hide'";
                    }

                    if (utils::in_array_partial("[type=label]", $answerhide) && $item->name == "label") {
                        $cssAditional = " class='local_avaliador_hide'";
                    }

                    $return .= "<tr $cssAditional>";
                    if ($item->name != "label") {
                        $return .= "<th>" . format_string($item->name) . "</th>";
                        $return .= "<td>";
                    } else {
                        $return .= "<td colspan=2>";
                        $return .= $item->presentation;
                        $return .= "</td></tr>";
                        continue;
                    }

                    $value = $DB->get_record("feedback_value", ['item' => $item->id, 'completed' => $completed->id]);

                    switch ($item->typ) {
                        case 'textfield':
                        case 'numeric':
                            $return .= format_string($value->value);
                            break;
                        case 'textarea':
                            $text = utils::indetifyAndConvertLinksInText($value->value);
                            $return .= format_text($text);
                            unset($text);
                            break;

                        case 'multichoice':
                            $choices = utils::item_get_options($item);
                            if (strpos($value->value, "|") > 0) {
                                $temp = [];
                                foreach (explode("|", $value->value) as $v) {
                                    $temp[] = html_writer::tag('li', $choices[format_string($v)]);
                                }
                                $return .= "<ul style='text-align:left'>" . implode("", $temp) . "</ul>";
                            } else {
                                $return .= $choices[$value->value] ?? "<i>Não selecionado</i>";
                            }
                            break;

                        default:
                            $return .= format_text($value->value);
                            break;
                    }
                    $return .= "</td>";
                    $return .= "</tr>";
                }
                $return .= "</table>";
                break;

            default:
                $return .= html_writer::tag('p', 'Atividade não suportada ou sem respostas.');
        }

        $return .= home::renderStyle();
        $return .= self::renderStyle();

        return $return;
    }

    public static function renderStyle()
    {
        $return = "
        <style scoped>
            .local_avaliador_table_answer {
                width: 100%;
            }
            .local_avaliador_table_answer td, th {
                padding: 5px 0px 5px 10px;
            }            
            .local_avaliador_table_answer tr:nth-child(odd) {
                background-color: #EEE;
                }
            .local_avaliador_highlight {
                background-color: palegoldenrod;
            }
            .local_avaliador_hide {
                display: none;
            }
        </style>
        ";
        return $return;
    }
}
