<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

namespace local_avaliador\models;

use local_avaliador\utils;
use stdClass;

class useranswers
{

    public static function updateOrCreate($itens) 
    {
        global $DB, $USER;
        $obj = new stdClass();
        foreach ($itens as $key => $value) {
            $obj->{$key} = $value;
        }
        
        $record = $DB->get_record('local_avaliador_users_answer', [
            'userid' => $obj->userid,
            'avaliadorid' => $obj->avaliadorid,
            'courseid' => $obj->courseid,
            'coursesectionid' => $obj->coursesectionid,
            'feedbackid' => $obj->feedbackid,
        ]);
        if ($record) {
            $record->timemodified = time();
            $record->completedid = $obj->completedid ;
            $DB->update_record('local_avaliador_users_answer', $record);
            return true;
        } 
        
        $DB->insert_record('local_avaliador_users_answer', $obj);
    }
    
    public static function hasUserAvaliadorAnswer($sectionid, $avaliadorid)
    {
        global $DB, $USER;

        $feedbackid = get_config('local_avaliador', 'feedbackid');
        
        $return = $DB->get_record('local_avaliador_users_answer', [
            'userid' => $USER->id,
            'avaliadorid' => $avaliadorid,
            'coursesectionid' => $sectionid,
            'feedbackid' => $feedbackid,
        ], 'completedid');

        return $return->completedid ?? 0;
    }
}
