<?php
/* Desenvolvido por Level Sistemas (http://www.levelsistemas.com.br)
** Contato: contato@levelsistemas.com.br */

use local_avaliador\models\useranswers;
use local_avaliador\pages\answer;
use local_avaliador\utils;

require_once('../../config.php');
require_once($CFG->libdir . '/formslib.php');
require_once($CFG->dirroot . '/mod/feedback/lib.php');

global $DB, $USER, $PAGE, $OUTPUT, $CFG, $SESSION;

class avaliador_mod_feedback_completion extends mod_feedback_completion
{
    public function getForm()
    {
        return $this->form;
    }
    public function setForm($form)
    {
        $this->form = $form;
    }
}

// Obtém o ID da sessão e o ID do avaliador
$sectionid = optional_param('sectionid', null, PARAM_INT);
if (empty($sectionid) && !empty($SESSION->local_avaliador['answer'])) {
    $sectionid = $SESSION->local_avaliador['answer']['sectionid'];
    $userid =    $SESSION->local_avaliador['answer']['avaliadorid'];
    $courseid =  $SESSION->local_avaliador['answer']['courseid'];
} else {
    $courseid = required_param('courseid', PARAM_INT);
    $sectionid = required_param('sectionid', PARAM_INT);
    $userid = required_param('avaliadorid', PARAM_INT);

    $SESSION->local_avaliador = [
        'answer' => [
            'courseid' => $courseid,
            'avaliadorid' => $userid,
            'sectionid' => $sectionid
        ]
    ];
}

$feedbackid = get_config('local_avaliador', 'feedbackid');

$thisUrl = new moodle_url('/local/avaliador/answer.php', [
    'courseid' => $courseid,
    'avaliadorid' => $userid,
    'sectionid' => $sectionid
]);

// Verifica se o feedback com o ID fornecido existe
$feedback = $DB->get_record('feedback', ['id' => $feedbackid]);
if (!$feedback) {
    print_error('Feedback não encontrado.');
}

// Obtém o módulo do curso (course module) usando o feedbackid
$cm = get_coursemodule_from_instance('feedback', $feedbackid);
if (!$cm) {
    print_error('Módulo do curso não encontrado.');
}

// Carrega o curso com base no módulo do curso (Course Module)
$course = $DB->get_record('course', ['id' => $courseid], '*', MUST_EXIST);
$section = $DB->get_record('course_sections', ['id' => $sectionid], 'name', MUST_EXIST);
$user = $DB->get_record('user', ['id' => $userid], '*', MUST_EXIST);

// Define o contexto do módulo do feedback
$context = context_module::instance($cm->id); // Contexto do módulo

// Define a URL da página atual
$PAGE->set_url($thisUrl);

// Define o título e o cabeçalho da página
$PAGE->set_title(format_string($feedback->name));
$title = format_string($course->fullname . " - " . $section->name . " : " . fullname($user));
$PAGE->set_heading($title);
$PAGE->set_pagelayout('incourse');

// -----------------------------------------------------------------------------

feedback_init_feedback_session();

// Verifica se o feedback está aberto
$completedid  = optional_param('useranswerid', null, PARAM_INT);
if (!empty($completedid)) {
    $feedbackcompletion = new avaliador_mod_feedback_completion($feedback, $cm, $courseid, true, $completedid);
} else {
    $feedbackcompletion = new avaliador_mod_feedback_completion($feedback, $cm, $courseid, false);
}

if (!$feedbackcompletion->is_open()) {
    utils::dd("QUANDO");
    echo $OUTPUT->header();
    echo $OUTPUT->box_start('generalbox boxaligncenter');
    echo $OUTPUT->notification(get_string('feedback_is_not_open', 'feedback'));
    echo $OUTPUT->continue_button(course_get_url($courseid ?: $feedback->course));
    echo $OUTPUT->box_end();
    echo $OUTPUT->footer();
    exit;
}

$feedbackcompletion->set_module_viewed();

// Verifica se o usuário pode submeter
$cansubmit = $feedbackcompletion->can_submit();

// Inicializa o processamento do formulário
if (!$feedbackcompletion->is_empty() && $cansubmit) {

    $feedbackcompletion->setForm(new mod_feedback_complete_form(
        mod_feedback_complete_form::MODE_COMPLETE,
        $feedbackcompletion,
        'feedback_complete_form',
        array('gopage' => 0)
    ));

    if ($feedbackcompletion->getForm()->is_submitted() && $feedbackcompletion->getForm()->is_validated()) {
        if (empty($completedid)) {
            $completedid = useranswers::hasUserAvaliadorAnswer($sectionid, $userid);
        }
        if ($completedid > 0) {
            $DB->delete_records('feedback_value', array('completed' => $completedid));
            $DB->delete_records('feedback_completed', array('id' => $completedid));
        }
        $data = $feedbackcompletion->getForm()->get_submitted_data();
        foreach ($feedbackcompletion->get_items() as $item) {
            if (strpos(strtolower($item->label), 'auto') !== false) {
                $label = explode("=", strtolower($item->label));
                switch (trim($label[1])) {
                    case 'escola':
                        $data->{$item->typ . "_" . $item->id} = fullname($user);
                        break;
                    case 'fase':
                        $data->{$item->typ . "_" . $item->id} = $course->fullname;
                        break;
                    case 'avaliador':
                        $data->{$item->typ . "_" . $item->id} = fullname($USER);
                        break;
                    case 'missao':
                        $data->{$item->typ . "_" . $item->id} = $section->name;
                        break;
                }
            }
        };

        // utils::dd($data);
        $feedbackcompletion->save_response_tmp($data);
        $feedbackcompletion->save_response();
        useranswers::updateOrCreate([
            'userid' => $USER->id,
            'avaliadorid' => $userid,
            'courseid' => $courseid,
            'coursesectionid' => $sectionid,
            'timecreated' => time(),
            'feedbackid' => $feedbackid,
            'completedid' => $feedbackcompletion->get_completed()->id,
        ]);

        redirect(new moodle_url('/local/avaliador/index.php', [
            'id' => $courseid,
        ]));
    }
}

echo $OUTPUT->header();

$answer = new answer($sectionid, $userid, $courseid);
$answer->renderPage();

if ($cansubmit && !$feedbackcompletion->just_completed()) {
    $css = "";
    foreach ($feedbackcompletion->get_items() as $item) {
        if (strpos(strtolower($item->label), 'auto') !== false) {
            $label = explode("=", strtolower($item->label));
            $css .= " #fitem_id_".$item->typ . "_" . $item->id." {display:none} ";
        }
    }
    echo $feedbackcompletion->render_items();
    echo "<style scoped>".$css."</style>";
}
echo $OUTPUT->footer();
